/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.comp.Configuration;
import beaver.comp.State;
import beaver.comp.util.BitSet;
import beaver.comp.util.Log;
import beaver.spec.Grammar;
import beaver.spec.GrammarSymbol;
import beaver.spec.NonTerminal;
import beaver.spec.Production;
import beaver.spec.Terminal;
import java.util.Arrays;
import java.util.Comparator;

class Action {
    static final Comparator LOOKAHEAD_ID_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Action)o1).lookahead.id - ((Action)o2).lookahead.id;
        }
    };
    Action next;
    Type type;
    GrammarSymbol lookahead;

    Action(Type type, GrammarSymbol lookahead) {
        this.type = type;
        this.lookahead = lookahead;
    }

    short getId() {
        return 0;
    }

    boolean resolveConflict(Action act, State state, Log log) {
        throw new IllegalStateException("only shift-reduce or reduce-reduce conflicts are expected");
    }

    public String toString() {
        return this.lookahead + ": " + this.type;
    }

    static class Accept
    extends Action {
        private short id;

        Accept(Grammar grammar) {
            super(Type.ACCEPT, grammar.goal_symbol);
            this.id = (short)(~grammar.rules.length);
        }

        short getId() {
            return this.id;
        }
    }

    static class List {
        static final Comparator NUM_ACTIONS_CMP = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((List)o2).num_actions - ((List)o1).num_actions;
            }
        };
        State state;
        Action first;
        Action last;
        int num_actions;

        List(State state) {
            this.state = state;
        }

        void add(Action act) {
            this.last = this.last == null ? (this.first = act) : (this.last.next = act);
            ++this.num_actions;
        }

        int resolveConflicts(Log log) {
            int num_conflicts = 0;
            if (this.first != null && this.num_actions > 1) {
                Action act = this.first;
                while (act != this.last) {
                    if (!act.type.isResolved()) {
                        Action cmp = act.next;
                        while (cmp != null) {
                            if (cmp.lookahead == act.lookahead && !act.resolveConflict(cmp, this.state, log)) {
                                ++num_conflicts;
                            }
                            cmp = cmp.next;
                        }
                    }
                    act = act.next;
                }
                this.removeResolvedActions();
            }
            return num_conflicts;
        }

        void reportConflicts(Log log) {
            if (this.first != null && this.num_actions > 1) {
                Action act = this.first;
                while (act != null) {
                    if (act.type instanceof Type.Conflict) {
                        log.error(act.type.toString());
                    }
                    act = act.next;
                }
            }
        }

        private void removeResolvedActions() {
            while (this.first != null && this.first.type.isRemovable()) {
                this.first = this.first.next;
                --this.num_actions;
            }
            this.last = this.first;
            Action next = this.first.next;
            while (next != null) {
                if (next.type.isRemovable()) {
                    --this.num_actions;
                } else {
                    this.last = this.last.next = next;
                }
                next = next.next;
            }
            this.last.next = null;
        }

        void markReducibleProductions() {
            Action act = this.first;
            while (act != null) {
                if (act.type == Type.REDUCE) {
                    ((Reduce)act).rule.is_reducible = true;
                }
                act = act.next;
            }
        }

        void compress() {
            Production maxrule = null;
            int maxcnt = 0;
            Action act = this.first;
            while (act != null) {
                Production rule;
                if (act.type == Type.REDUCE && (rule = ((Reduce)act).rule) != maxrule) {
                    int cnt = 1;
                    Action cmp = act.next;
                    while (cmp != null) {
                        if (cmp.type == Type.REDUCE && ((Reduce)cmp).rule == rule) {
                            ++cnt;
                        }
                        cmp = cmp.next;
                    }
                    if (cnt > maxcnt) {
                        maxrule = rule;
                        maxcnt = cnt;
                    }
                }
                act = act.next;
            }
            if (maxcnt > 1) {
                act = this.first;
                while (act.type != Type.REDUCE || ((Reduce)act).rule != maxrule) {
                    act = act.next;
                }
                act.lookahead = null;
                act = act.next;
                while (act != null) {
                    if (act.type == Type.REDUCE && ((Reduce)act).rule == maxrule) {
                        act.type = Type.NOT_USED;
                    }
                    act = act.next;
                }
            }
        }

        Action split(List terminal_actions, List nonterminal_actions) {
            Action default_act = null;
            Action first_not_used = null;
            Action last_not_used = null;
            this.num_actions = 0;
            Action act = this.first;
            while (act != null) {
                if (act.type.isRemovable()) {
                    last_not_used = last_not_used == null ? (first_not_used = act) : (last_not_used.next = act);
                    ++this.num_actions;
                } else if (act.lookahead instanceof NonTerminal) {
                    nonterminal_actions.add(act);
                } else if (act.lookahead instanceof Terminal) {
                    terminal_actions.add(act);
                } else {
                    if (default_act != null) {
                        throw new IllegalStateException("multiple default actions in state " + this.state.id + " actions list");
                    }
                    default_act = act;
                }
                act = act.next;
            }
            this.first = first_not_used;
            this.last = last_not_used;
            if (last_not_used != null) {
                last_not_used.next = null;
            }
            if (default_act != null) {
                default_act.next = null;
            }
            if (terminal_actions.last != null) {
                terminal_actions.last.next = null;
            }
            if (nonterminal_actions.last != null) {
                nonterminal_actions.last.next = null;
            }
            terminal_actions.sort();
            nonterminal_actions.sort();
            return default_act;
        }

        void sort() {
            if (this.num_actions > 1) {
                Action[] actions = new Action[this.num_actions];
                int i = 0;
                Action act = this.first;
                while (act != null) {
                    actions[i++] = act;
                    act = act.next;
                }
                Arrays.sort(actions, LOOKAHEAD_ID_COMPARATOR);
                i = 0;
                act = this.first = actions[0];
                while (++i < this.num_actions) {
                    act = act.next = actions[i];
                }
                this.last = act;
                act.next = null;
            }
        }
    }

    static class Reduce
    extends Action {
        Production rule;

        Reduce(Terminal lookahead, Production rule) {
            super(Type.REDUCE, lookahead);
            this.rule = rule;
        }

        boolean resolveConflict(Action act, State act_state, Log log) {
            if (!(act instanceof Reduce)) {
                throw new IllegalArgumentException("reduce-reduce expected");
            }
            Terminal my_prec_sym = this.rule.prec_sym;
            Reduce reduce_act = (Reduce)act;
            Terminal act_prec_sym = reduce_act.rule.prec_sym;
            if (my_prec_sym.prec > act_prec_sym.prec) {
                act.type = Type.RESOLVED;
                return true;
            }
            if (my_prec_sym.prec < act_prec_sym.prec) {
                this.type = Type.RESOLVED;
                return true;
            }
            act.type = new Type.Conflict.ReduceReduce(this, reduce_act, act_state, "equal precedence");
            return false;
        }

        short getId() {
            return (short)(~this.rule.id);
        }

        public String toString() {
            return this.lookahead != null ? this.lookahead + ": " + this.type + " " + this.rule : "[any]: REDUCE " + this.rule;
        }

        static class Maker
        extends BitSet.Processor {
            Terminal[] terminals;
            State state;
            Production rule;

            Maker(Terminal[] terminals, State first_state) {
                this.terminals = terminals;
                this.state = first_state;
            }

            void buildReduceActions() {
                while (this.state != null) {
                    Configuration conf = this.state.conf_set.first_conf;
                    while (conf != null) {
                        if (conf.dot == conf.rule.rhs.items.length) {
                            this.rule = conf.rule;
                            conf.lookaheads.forEachElementRun(this);
                        }
                        conf = conf.next;
                    }
                    this.state = this.state.next;
                }
            }

            protected void process(int index) {
                this.state.actions.add(new Reduce(this.terminals[index], this.rule));
            }
        }
    }

    static class Shift
    extends Action {
        State state;

        Shift(GrammarSymbol lookahead, State state) {
            super(Type.SHIFT, lookahead);
            this.state = state;
        }

        boolean resolveConflict(Action act, State act_state, Log log) {
            if (!(act instanceof Reduce)) {
                throw new IllegalArgumentException("shift-reduce expected, \"" + act + "\" found");
            }
            Reduce reduce_act = (Reduce)act;
            Terminal reduce_prec_sym = reduce_act.rule.prec_sym;
            if (this.lookahead instanceof NonTerminal) {
                act.type = new Type.Conflict.ShiftReduce(this, reduce_act, act_state, String.valueOf(this.lookahead.name) + " is a non-terminal");
                return false;
            }
            Terminal shift_prec_sym = (Terminal)this.lookahead;
            if (shift_prec_sym.prec > reduce_prec_sym.prec) {
                if (reduce_prec_sym.prec < 0) {
                    log.warning("Resolved Shift-Reduce conflict by selecting (" + this.toString() + ") over (" + act.toString() + ") using precedence.");
                }
                act.type = Type.RESOLVED;
                return true;
            }
            if (shift_prec_sym.prec < reduce_prec_sym.prec) {
                if (shift_prec_sym.prec < 0) {
                    log.warning("Resolved Shift-Reduce conflict by selecting (" + act.toString() + ") over (" + this.toString() + ") using precedence.");
                }
                this.type = Type.RESOLVED;
                return true;
            }
            if (shift_prec_sym.assoc == Terminal.Associativity.RIGHT) {
                act.type = Type.RESOLVED;
                return true;
            }
            if (shift_prec_sym.assoc == Terminal.Associativity.LEFT) {
                this.type = Type.RESOLVED;
                return true;
            }
            act.type = new Type.Conflict.ShiftReduce(this, reduce_act, act_state, shift_prec_sym.prec > 0 ? String.valueOf(this.lookahead.name) + " is nonassociative" : "insufficient precedence information");
            return false;
        }

        short getId() {
            return (short)this.state.id;
        }

        public String toString() {
            return this.lookahead + ": " + this.type + "; goto " + this.state.id;
        }
    }

    static class Type {
        static final Type SHIFT = new Type(1, "SHIFT");
        static final Type REDUCE = new Type(2, "REDUCE");
        static final Type ACCEPT = new Type(3, "ACCEPT");
        static final Type RESOLVED = new Type(-1, "RESOLVED");
        static final Type NOT_USED = new Type(-2, "NOT USED");
        private int id;
        private String name;

        Type(int id, String name) {
            this.id = id;
            this.name = name;
        }

        boolean isRemovable() {
            return this.id < 0;
        }

        boolean isResolved() {
            return this.id <= 0;
        }

        public String toString() {
            return this.name;
        }

        static class Conflict
        extends Type {
            private String descr;

            Conflict(String type, String details) {
                super(0, String.valueOf(type) + " conflict");
                this.descr = details;
            }

            public String toString() {
                return new StringBuffer(super.toString().length() + 2 + this.descr.length()).append(super.toString()).append(": ").append(this.descr).toString();
            }

            static class ReduceReduce
            extends Conflict {
                ReduceReduce(Reduce act1, Reduce act2, State state, String reason) {
                    super("reduce-reduce", ReduceReduce.makeDescription(act1, act2, state, reason));
                }

                private static String makeDescription(Reduce act1, Reduce act2, State state, String reason) {
                    StringBuffer text = new StringBuffer(256).append("\n\treduce\t").append(act1.rule);
                    int line = act1.rule.getFirstLine();
                    if (line > 0) {
                        text.append(" @ ").append(line);
                    }
                    text.append("\n\tor\t").append(act2.rule);
                    line = act2.rule.getFirstLine();
                    if (line > 0) {
                        text.append(" @ ").append(line);
                    }
                    text.append("\n\ton ").append(act1.lookahead.name).append(" - ").append(reason);
                    return text.toString();
                }
            }

            static class ShiftReduce
            extends Conflict {
                ShiftReduce(Shift shift_act, Reduce reduce_act, State state, String reason) {
                    super("shift-reduce", ShiftReduce.makeDescription(shift_act, reduce_act, state, reason));
                }

                private static String makeDescription(Shift shift_act, Reduce reduce_act, State state, String reason) {
                    StringBuffer text = new StringBuffer(256).append("\n\tshift ").append(shift_act.lookahead.name).append(" in:");
                    Configuration conf = state.conf_set.first_conf;
                    while (conf != null) {
                        if (conf.dot < conf.rule.rhs.items.length && conf.rule.rhs.items[conf.dot].symbol == shift_act.lookahead) {
                            text.append("\n\t\t").append(conf);
                        }
                        conf = conf.next;
                    }
                    text.append("\n\tor reduce:\n\t\t").append(reduce_act.rule.toString());
                    int line = reduce_act.rule.getFirstLine();
                    if (line > 0) {
                        text.append(" @ ").append(line);
                    }
                    text.append("\n\t- ").append(reason);
                    return text.toString();
                }
            }
        }
    }
}

